#!/usr/bin/env bash

set -e

echo ""
echo "Welcome to Media Plane installation!"
echo "- Download dependencies from Gizmify's repo."
echo "- Install Maya module to $HOME/maya/modules."
read -p "Continue? [y/n] " choice
case "$choice" in
    y|Y ) echo "";;
    n|N ) echo "Bye."; exit 0;;
    * ) echo "Invalid choice. Bye."; exit 1;;
esac

here="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"

depends_url="https://depends.gizmify-static.net/mediaplane/linux/x86-64/v0.0.1/ffmpeg_libs_lgpl_6.1.tar.gz"
libDir="$here/lib"
fileName="$(basename "$depends_url")"

echo " - Downloading $fileName..."
curl -L -o "$libDir/$fileName" "$depends_url"

echo " - Extracting $fileName..."
tar -xzf "$libDir/$fileName" -C "$libDir"

echo " - Cleaning up..."
rm "$libDir/$fileName"

echo " - Installing Maya module..."
locPtrn="<INSTALL_LOCATION>"
modulesFile="$here/modules/MediaPlane.mod"
sed -i "s|${locPtrn}|${here}|g" "$modulesFile"
mkdir -p "$HOME/maya/modules"
cp "$modulesFile" "$HOME/maya/modules"

echo "Done."